'use strict';

// Nav

const nav = document.querySelector('.nav');
const navBackdrop = document.querySelector('.nav__backdrop');
const navList = document.querySelector('.nav__list');
const navItems = document.querySelectorAll('.nav__item');
const navDropdowns = document.querySelectorAll('.nav__dropdown');
const navToggleBtn = document.querySelector('#nav-toggle');

function resetNavItemsDropdowns() {
  navItems.forEach(el => el.classList.remove('nav__item--active'));
}

function hideNavBackdrop() {
  navBackdrop.classList.add('hidden');
  navDropdowns.forEach(el => el.classList.add('hidden'));
}

navList.addEventListener('click', e => {
  const target = e.target.closest('.nav__item');

  if (!target) return;

  const dropdown = document.querySelector(`.nav__dropdown--${target.dataset.dropdown}`);

  if (!dropdown) return;

  resetNavItemsDropdowns();
  target.classList.add('nav__item--active');

  navBackdrop.classList.remove('hidden');
  dropdown.classList.remove('hidden');
});

navToggleBtn.addEventListener('click', () => {
  navToggleBtn.classList.toggle('nav-btn--active');
  navToggleBtn.classList.toggle('nav-btn--inactive');
  nav.classList.toggle('nav--active');

  hideNavBackdrop();
  resetNavItemsDropdowns();
});

navBackdrop.addEventListener('click', e => {
  if (e.target === navBackdrop) {
    hideNavBackdrop();
    resetNavItemsDropdowns();
  }
});

// Droppers

const droppers = document.querySelectorAll('.dropper');

if (droppers.length > 0) {
  droppers.forEach(el => {
    const dpContentWrapper = el.querySelector('.dropper__content-wrapper');

    el.addEventListener('click', function (e) {
      if (
        e.target.className === 'dropper__heading' ||
        e.target.parentElement.className === 'dropper__heading'
      ) {
        el.classList.toggle('dropper--active');

        if (el.classList.contains('dropper--active')) {
          dpContentWrapper.style.height = dpContentWrapper.scrollHeight + 'px';
        } else {
          dpContentWrapper.style.height = 0;
        }
      }
    });
  });
}

// Cookie message

const cookieMessage = document.querySelector('.cookie-message');

if (localStorage.getItem('cookiesAccepted') !== '1')
  cookieMessage.classList.remove('hidden');

cookieMessage.addEventListener('click', e => {
  if (e.target.classList.contains('btn-text')) {
    cookieMessage.classList.add('hidden');

    localStorage.setItem('cookiesAccepted', '1');
  }
});

// Lists grid item count

const uLists = Array.from(document.querySelectorAll('.u-list--horizontal'));

uLists.forEach(el => {
  if (el.classList.contains('u-list--stretch-cols')) return;

  const childCount = el.children.length;

  el.style.gridTemplateColumns = `repeat(${childCount}, minmax(0, 1fr))`;
});

// Rating popup

const ratingContainer = document.querySelector('.rating');
const ratingStarsContainer = document.querySelector('.rating__stars');
const ratingStars = Array.from(document.querySelectorAll('.rating__star > span'));

let ratingGiven = Boolean(localStorage.getItem('ratingGiven')) || false;

if (!ratingGiven) {
  setTimeout(() => {
    ratingContainer.classList.remove('hidden-hard');

    animation_ratingPopupOpening.play();
  }, 20000);
}

function unfillRatingStars() {
  ratingStars.forEach(star => (star.textContent = 'star_outline'));
}

ratingStarsContainer.addEventListener('mouseover', e => {
  if (ratingGiven) return;

  if (!e.target.classList.contains('material-icons')) return;

  for (const [i, star] of ratingStars.entries()) {
    if (ratingStars[i - 1] === e.target) break;

    star.textContent = 'star';
  }
});

ratingStarsContainer.addEventListener('click', e => {
  if (ratingGiven) return;

  const target = e.target.closest('.rating__star > span');

  if (!target) return;

  const rating = ratingStars.filter(el => el.textContent === 'star').length;

  ratingGiven = true;
  localStorage.setItem('ratingGiven', 'true');

  setTimeout(() => {
    animation_ratingPopupClosing.play();

    setTimeout(() => {
      ratingContainer.classList.add('hidden-hard');
    }, 3000);
  }, 3000);
});

ratingStarsContainer.addEventListener('mouseleave', e => {
  if (!ratingGiven) unfillRatingStars();
});

ratingStars.forEach(star => {
  star.addEventListener('mouseleave', () => {
    if (!ratingGiven) unfillRatingStars();
  });
});

// TODO: Save rating

// Facebook notification

const facebookNotification = document.querySelector('.facebook');
const hideFacebookNotification = localStorage.getItem('hideFacebookNotification');

if (!hideFacebookNotification) {
  setTimeout(function () {
    facebookNotification.classList.remove('hidden');

    animation_facebookNotificationLabel.play();
    animation_facebookNotificationMessage.play();
  }, 12000);

  facebookNotification
    .querySelector('.facebook__close')
    .addEventListener('click', function () {
      facebookNotification.classList.add('hidden');

      animation_facebookNotificationLabel.pause();
      animation_facebookNotificationMessage.pause();

      localStorage.setItem('hideFacebookNotification', 'true');
    });
}
