<?php get_header(); ?>

<header class="t-flex flex-col w-full h-screen bg-no-repeat bg-cover ps-28 relative overflow-hidden competition-header" style="background-image: url('<?php echo get_theme_file_uri("/assets/img/konkurs-bg.jpg"); ?>');">
	<div class="mt-6 w-max">
		<a class="m-flex items-center gap-4 btn-cta btn-cta--alt" href="<?= get_attachment_link(72); ?>">
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-10">
				<path fill-rule="evenodd" d="M5.625 1.5c-1.036 0-1.875.84-1.875 1.875v17.25c0 1.035.84 1.875 1.875 1.875h12.75c1.035 0 1.875-.84 1.875-1.875V12.75A3.75 3.75 0 0 0 16.5 9h-1.875a1.875 1.875 0 0 1-1.875-1.875V5.25A3.75 3.75 0 0 0 9 1.5H5.625ZM7.5 15a.75.75 0 0 1 .75-.75h7.5a.75.75 0 0 1 0 1.5h-7.5A.75.75 0 0 1 7.5 15Zm.75 2.25a.75.75 0 0 0 0 1.5H12a.75.75 0 0 0 0-1.5H8.25Z" clip-rule="evenodd" />
				<path d="M12.971 1.816A5.23 5.23 0 0 1 14.25 5.25v1.875c0 .207.168.375.375.375H16.5a5.23 5.23 0 0 1 3.434 1.279 9.768 9.768 0 0 0-6.963-6.963Z" />
			</svg>
			<span>Regulamin</span>
		</a>
	</div>
	<div class="t-flex flex-col gap-2 w-2/3 h-1/2 mt-64">
		<h1 class="competition-header__heading uppercase text-primary font-bold">Konkurs recytatorski w IX Prywatnym</h1>
		<h2 class="competition-header__subheading">Liceum Ogólnokształcącym</h2>
	</div>
	<img class="competition-header__logo" src="<?= get_theme_file_uri("assets/img/logo.png?as=webp") ?>" alt="" />
</header>

<section class="w-full py-12 overflow-hidden lg:invisible" id="competition-section">
	<!-- <section class="w-full py-12 overflow-hidden" id="competition-section"> -->
	<h3 class="competition-heading text-center uppercase text-primary mt-6 mb-2" data-competition-heading-to-animate>Poznaj naszych jurorów</h3>

	<!-- <div class="t-flex max-lg:flex-col items-center py-8"> -->
	<div class="t-flex max-lg:flex-col items-center py-8 max-lg:!py-2 max-lg:gap-8">
		<div class="splide lg:hidden" id="competition-carousel">
			<div class="splide__track" style="overflow: visible !important;">
				<div class="splide__list">
					<div class="splide__slide t-flex justify-center items-center">
						<video class="w-full h-full" poster="<?php echo get_theme_file_uri("/assets/img/konkurs-video-left-thumbnail.jpg"); ?>" controls>
							<source src="<?php echo get_theme_file_uri("/assets/img/konkurs-video-left.mp4") ?>" type="video/mp4">
						</video>
					</div>
					<div class="splide__slide t-flex justify-center items-center">
						<video class="w-full h-full" poster="<?php echo get_theme_file_uri("/assets/img/konkurs-video-right-thumbnail.jpg"); ?>" controls>
							<source src="<?php echo get_theme_file_uri("/assets/img/konkurs-video-right.mp4") ?>" type="video/mp4">
						</video>
					</div>
				</div>
			</div>
		</div>

		<div class="t-flex justify-center flex-1 max-lg:hidden" style="transform: rotate(-2deg);" data-competition-video-left-to-animate>
			<video class="w-full h-full" id="video-left" poster="<?php echo get_theme_file_uri("/assets/img/konkurs-video-left-thumbnail.jpg"); ?>" controls>
				<source src="<?php echo get_theme_file_uri("/assets/img/konkurs-video-left.mp4") ?>" type="video/mp4">
			</video>
		</div>

		<div class="t-flex flex-col gap-12 text-center justify-center items-center lg:flex-1 max-md:w-full max-md:px-12 max-lg:w-1/2">
			<div class="t-flex flex-col gap-6 competition-content" data-competition-content-to-animate>
				<?php the_content(); ?>
			</div>

			<a class="m-flex w-max items-center gap-4 btn-cta btn-cta--alt" href="<?= get_attachment_link(73); ?>" data-competition-button-cta-to-animate>
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-10">
					<path fill-rule="evenodd" d="M5.625 1.5H9a3.75 3.75 0 0 1 3.75 3.75v1.875c0 1.036.84 1.875 1.875 1.875H16.5a3.75 3.75 0 0 1 3.75 3.75v7.875c0 1.035-.84 1.875-1.875 1.875H5.625a1.875 1.875 0 0 1-1.875-1.875V3.375c0-1.036.84-1.875 1.875-1.875Zm5.845 17.03a.75.75 0 0 0 1.06 0l3-3a.75.75 0 1 0-1.06-1.06l-1.72 1.72V12a.75.75 0 0 0-1.5 0v4.19l-1.72-1.72a.75.75 0 0 0-1.06 1.06l3 3Z" clip-rule="evenodd" />
					<path d="M14.25 5.25a5.23 5.23 0 0 0-1.279-3.434 9.768 9.768 0 0 1 6.963 6.963A5.23 5.23 0 0 0 16.5 7.5h-1.875a.375.375 0 0 1-.375-.375V5.25Z" />
				</svg>

				<span>Zgłoś się!</span>
			</a>
		</div>

		<div class="t-flex justify-center flex-1 max-lg:hidden" style="transform: rotate(2deg);" data-competition-video-right-to-animate>
			<video class="w-full h-full" id="video-right" poster="<?php echo get_theme_file_uri("/assets/img/konkurs-video-right-thumbnail.jpg"); ?>" controls>
				<source src="<?php echo get_theme_file_uri("/assets/img/konkurs-video-right.mp4") ?>" type="video/mp4">
			</video>
		</div>
	</div>
</section>



<?php get_footer(); ?>